/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.tiviacz.travelersbackpack.common.BackpackManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class RestoreBackpackCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_PROVIDER = (context, builder) -> {
        File backpacksFolder = BackpackManager.getBackpackFolder(((CommandSourceStack)context.getSource()).m_81372_());
        if (backpacksFolder.listFiles() == null) {
            return Suggestions.empty();
        }
        ArrayList backpackEntries = new ArrayList();
        for (File file : backpacksFolder.listFiles((dir, name) -> name.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$"))) {
            if (file.listFiles() == null) continue;
            backpackEntries.addAll(Arrays.stream(file.listFiles()).collect(ArrayList::new, (list, backpack) -> list.add(backpack.getName()), List::addAll));
        }
        return SharedSuggestionProvider.m_82981_(backpackEntries.stream(), (SuggestionsBuilder)builder);
    };

    public RestoreBackpackCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"tb").requires(player -> player.m_6761_(2));
        tbCommand.then(Commands.m_82127_((String)"restore").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"backpack_id", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER).executes(source -> this.restoreBackpack((CommandSourceStack)source.getSource(), StringArgumentType.getString((CommandContext)source, (String)"backpack_id"), EntityArgument.m_91474_((CommandContext)source, (String)"target"))))));
        dispatcher.register(tbCommand);
    }

    public int restoreBackpack(CommandSourceStack source, String backpackId, ServerPlayer player) {
        ItemStack backpack = BackpackManager.getBackpack(player.m_9236_(), backpackId);
        if (backpack == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Backpack with ID " + backpackId + " not found")));
            return 0;
        }
        if (!player.m_150109_().m_36054_(backpack)) {
            player.m_36176_(backpack, false);
        }
        source.m_81354_((Component)Component.m_237113_((String)("Successfully restored " + player.m_5446_().getString() + "'s backpack")), true);
        return 1;
    }
}

